#!/bin/sh

# This tool compiles textual messages from the message catalogues for
# imip-agent using the gettext software.
#
# Copyright (C) 2015, 2016 Paul Boddie <paul@boddie.org.uk>
#
# This program is free software; you can redistribute it and/or modify it under
# the terms of the GNU General Public License as published by the Free Software
# Foundation; either version 3 of the License, or (at your option) any later
# version.
#
# This program is distributed in the hope that it will be useful, but WITHOUT
# ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
# FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
# details.
#
# You should have received a copy of the GNU General Public License along with
# this program.  If not, see <http://www.gnu.org/licenses/>.

if ! which msgfmt > /dev/null 2>&1 ; then
    exit 1
fi

DOMAIN=imip-agent

for FILENAME in messages/*.po ; do
    LOCALE_ID=`basename "$FILENAME" ".$DOMAIN.po"`
    mkdir -p "locale/$LOCALE_ID/LC_MESSAGES"
    msgfmt -o "locale/$LOCALE_ID/LC_MESSAGES/$DOMAIN.mo" "$FILENAME"
done
