# SPDX-License-Identifier: Apache-2.0
# SPDX-FileCopyrightText: Maciek Borzecki
AMAZONLINUX_RELEASES ?=
GARDEN_SYSTEMS += $(foreach r,$(AMAZONLINUX_RELEASES),$(foreach a,x86_64 aarch64,amazonlinux-cloud-$r.$a))

$(foreach R,$(AMAZONLINUX_RELEASES),amazonlinux-cloud-$R.x86_64.run): amazonlinux-cloud-%.x86_64.run: $(MAKEFILE_LIST) | amazonlinux-cloud-%.x86_64.qcow2 amazonlinux-cloud-%.x86_64.efi-code.img amazonlinux-cloud-%.x86_64.efi-vars.img
	echo "#!/bin/sh" >$@
	echo 'set -xeu' >>$@
	echo "# WARNING: The .qcow2 file refers to a file in $(GARDEN_DL_DIR)/amazonlinux" >>$@
	echo '$(strip exec $(call QEMU_SYSTEM_X86_64_EFI_CMDLINE,$(word 1,$|),$(word 2,$|),$(word 3,$|)) "$$@")' >>$@
	chmod +x $@

$(foreach R,$(AMAZONLINUX_RELEASES),amazonlinux-cloud-$R.aarch64.run): amazonlinux-cloud-%.aarch64.run: $(MAKEFILE_LIST) | amazonlinux-cloud-%.aarch64.qcow2 amazonlinux-cloud-%.aarch64.efi-code.img amazonlinux-cloud-%.aarch64.efi-vars.img
	echo "#!/bin/sh" >$@
	echo 'set -xeu' >>$@
	echo "# WARNING: The .qcow2 file refers to a file in $(GARDEN_DL_DIR)/amazonlinux" >>$@
	echo '$(strip exec $(call QEMU_SYSTEM_AARCH64_EFI_CMDLINE,$(word 1,$|),$(word 2,$|),$(word 3,$|)) "$$@")' >>$@
	chmod +x $@

$(foreach R,$(AMAZONLINUX_RELEASES),amazonlinux-cloud-$R.x86_64.qcow2): amazonlinux-cloud-%.x86_64.qcow2: $(GARDEN_DL_DIR)/amazonlinux/amazonlinux-cloud-%.x86_64.qcow2 amazonlinux-cloud-%.seed.iso amazonlinux-cloud-%.x86_64.efi-code.img amazonlinux-cloud-%.x86_64.efi-vars.img
	$(strip $(QEMU_IMG) create -f qcow2 -b $< -F qcow2 $@ $(QEMU_IMG_SIZE))
	$(strip $(call QEMU_SYSTEM_X86_64_EFI_CMDLINE,$@,$(word 3,$^),$(word 4,$^)) \
		-drive file=$(word 2,$^),format=raw,id=drive1,if=none,readonly=true,media=cdrom \
		-device virtio-blk,drive=drive1 \
		-no-reboot | tee $@.log)

$(foreach R,$(AMAZONLINUX_RELEASES),amazonlinux-cloud-$R.aarch64.qcow2): amazonlinux-cloud-%.aarch64.qcow2: $(GARDEN_DL_DIR)/amazonlinux/amazonlinux-cloud-%.aarch64.qcow2 amazonlinux-cloud-%.seed.iso amazonlinux-cloud-%.aarch64.efi-code.img amazonlinux-cloud-%.aarch64.efi-vars.img
	$(strip $(QEMU_IMG) create -f qcow2 -b $< -F qcow2 $@ $(QEMU_IMG_SIZE))
	$(strip $(call QEMU_SYSTEM_AARCH64_EFI_CMDLINE,$@,$(word 3,$^),$(word 4,$^)) \
		-drive file=$(word 2,$^),format=raw,id=drive1,if=none,readonly=true,media=cdrom \
		-device virtio-blk,drive=drive1 \
		-no-reboot | tee $@.log)

$(GARDEN_DL_DIR)/amazonlinux: | $(GARDEN_DL_DIR)
	mkdir -p $@

amazonlinux-cloud-%.meta-data: export META_DATA = $(call CLOUD_INIT_META_DATA_TEMPLATE,amazonlinux-$*)
amazonlinux-cloud-%.meta-data: $(MAKEFILE_LIST)
	echo "$${META_DATA}" | tee $@
	touch --reference=$(shell stat $^ -c '%Y %n' | sort -nr | cut -d ' ' -f 2 | head -n 1) $@

amazonlinux-cloud-%.user-data: export USER_DATA = $(call $(call PICK_CLOUD_INIT_USER_DATA_TEMPLATE_FOR,AMAZONLINUX,$*),amazonlinux-$*,amazonlinux)
amazonlinux-cloud-%.user-data: $(MAKEFILE_LIST) $(wildcard .image-garden.mk)
	echo "$${USER_DATA}" | tee $@
	touch --reference=$(shell stat $^ -c '%Y %n' | sort -nr | cut -d ' ' -f 2 | head -n 1) $@

.PHONY: clean
clean::
	rm -f $(foreach R,$(AMAZONLINUX_RELEASES),$(foreach A,x86_64 aarch64,amazonlinux-cloud-$R.$A.qcow2 amazonlinux-cloud-$R.$A.run))
