# A debhelper build system class for building Pd-externals with pd-lib-builder.
#
# Copyright: © 2022 IOhannes m zmölnig
# License: GPL-2+

package Debian::Debhelper::Buildsystem::pd_lib_builder;

use strict;
use warnings;
use Debian::Debhelper::Dh_Lib qw(compat);
use Dpkg::Version qw();

use parent qw(Debian::Debhelper::Buildsystem::makefile);

sub DESCRIPTION {
    "pd-lib-builder based externals"
}

sub new {
    # pd-lib-builder does not allow out-of-tree building
    my $class=shift;
    my $this=$class->SUPER::new(@_);
    $this->enforce_in_source_building();
    return $this;
}

sub _should_inject_cross_build_tools {
    return 1;
}

sub check_auto_buildable {
    # pd-lib-builder can be enabled if there is a makefile
    # that calls 'include $(PDLIBBUILDER_DIR)/Makefile.pdlibbuilder'
    my $this=shift;
    my ($step)=@_;
    foreach my $f ("Makefile", "makefile", "GNUmakefile") {
        my $f1 = $this->get_buildpath($f);
        if (! -e $f1) {
            next;
        }
        open (my $MAKEFILE, "<", $f1) || next;
        while (<$MAKEFILE>) {
            chomp;
            if (/^include \$\(PDLIBBUILDER_DIR\)\/Makefile\.pdlibbuilder/) {
                close $MAKEFILE;
                return ($this->SUPER::check_auto_buildable(@_)) + 1;
            }
        }
        close $MAKEFILE;
        return 0;
    }
    return 0;
}

sub clean {
    # use Debian's Makefile.pdlibbuilder by passing PDLIBBUILDER_DIR
    my $this=shift;
    unshift(@_, "PDLIBBUILDER_DIR=/usr/share/pd-lib-builder/");
    return $this->SUPER::clean(@_);
}

sub build {
    # use Debian's Makefile.pdlibbuilder by passing PDLIBBUILDER_DIR
    # also override CPPFLAGS, CFLAGS, LDFLAGS
    # and arch.c.flags (which contains optimization flags that exceed our baseline)
    my $this=shift;

    unshift(@_, "PDLIBBUILDER_DIR=/usr/share/pd-lib-builder/");
    unshift(@_, "CPPFLAGS=$ENV{CPPFLAGS}");
    unshift(@_, "CFLAGS=$ENV{CPPFLAGS} $ENV{CFLAGS}");
    unshift(@_, "LDFLAGS=$ENV{LDFLAGS}");
    unshift(@_, "arch.c.flags=");
    if (not compat(10)) {
        unshift @_, "INSTALL=install --strip-program=true";
    }

    return $this->SUPER::build(@_);
}

sub test {
    # use Debian's Makefile.pdlibbuilder by passing PDLIBBUILDER_DIR
    my $this=shift;
    unshift(@_, "PDLIBBUILDER_DIR=/usr/share/pd-lib-builder/");
    $this->SUPER::test(@_);
}

sub install {
    # use Debian's Makefile.pdlibbuilder by passing PDLIBBUILDER_DIR
    my $this=shift;
    my $destdir=shift;

    unshift(@_, "PDLIBBUILDER_DIR=/usr/share/pd-lib-builder/");
    unshift(@_, "prefix=/usr");
    unshift(@_, "pkglibdir=/usr/lib/pd/extra");
    if (not compat(10)) {
        unshift @_, "INSTALL=install --strip-program=true";
    }

    return $this->SUPER::install($destdir, @_);
}

1;
