![Banner](images/controku-banner.png#gh-dark-mode-only)
![Banner](images/controku-banner-inverted.png#gh-light-mode-only)
Controku is a library and GTK3 application that allows you to control
Roku devices from the comfort of your own desktop.

![Remote UI](images/remote.png#gh-dark-mode-only)
![Remote UI](images/remote-light.png#gh-light-mode-only)
![Connection UI](images/connect.png#gh-dark-mode-only)
![Connection UI](images/connect-light.png#gh-light-mode-only)

## Dependencies
* PyGObject (GUI only)
* [appdirs](https://github.com/ActiveState/appdirs) (GUI only)
* requests
* [SSDPy](https://github.com/MoshiBin/ssdpy)

### Note for Windows users
SSDPy, the library used to discover Roku devices on the local network,
has [problems on Windows](https://github.com/MoshiBin/ssdpy/issues/82)
that make device discovery impossible on the platform. Windows users
will need to use the Roku device's IP address as a command line
argument, or manually add it to the cache at
`C:\Users\username\AppData\Local\benthetechguy\controku\Cache\devices.json`
with the syntax `[{'name': 'device name here', 'ip': 'ip address here'}]`.

## Keyboard Control
Instead of just using the mouse, you also can press the following keys:

| Key on keyboard    | Key sent to Roku device |
| ------------------ | ----------------------- |
| Backspace or B     | Back                    |
| I                  | Info                    |
| Escape or H        | Home                    |
| WASD or arrow keys | Up, Down, Left, Right   |
| Enter, Space, or O | Select/OK               |
| , or R             | Rewind                  |
| . or F             | Fast Forward            |
| / or P             | Play/Pause              |
| [ or -             | Volume Down             |
| ] or +             | Volume Up               |
| \ or M             | Mute                    |

**Note**: Using the arrow keys unintentionally highlights different
buttons in the GUI, and pressing enter or space can activate one of
them. To prevent the activation of an unintended button like power or
home, it's recommended to instead use WASD for direction buttons and/or
use the O key for Select/OK.
