<a name="higher_order_functions"></a>

# Функции высшего порядка

## Оператор `->`, функция lambda(params, expr)

Позволяет описать лямбда-функцию для передачи в функцию высшего порядка. Слева от стрелочки стоит формальный параметр - произвольный идентификатор, или несколько формальных параметров - произвольные идентификаторы в кортеже. Справа от стрелочки стоит выражение, в котором могут использоваться эти формальные параметры, а также любые столбцы таблицы.

Примеры: `x -> 2 * x, str -> str != Referer.`

Функции высшего порядка, в качестве своего функционального аргумента могут принимать только лямбда-функции.

В функции высшего порядка может быть передана лямбда-функция, принимающая несколько аргументов. В этом случае, в функцию высшего порядка передаётся несколько массивов одинаковых длин, которым эти аргументы будут соответствовать.

Для всех функций кроме arrayMap, arrayFilter, первый аргумент (лямбда-функция) может отсутствовать. В этом случае, подразумевается тождественное отображение.

### arrayMap(func, arr1, ...)
Вернуть массив, полученный из исходного применением функции func к каждому элементу массива arr.

### arrayFilter(func, arr1, ...)
Вернуть массив, содержащий только те элементы массива arr1, для которых функция func возвращает не 0.

Примеры:

``` sql
SELECT arrayFilter(x -> x LIKE '%World%', ['Hello', 'abc World']) AS res
```

```
┌─res───────────┐
│ ['abc World'] │
└───────────────┘
```

``` sql
SELECT
    arrayFilter(
        (i, x) -> x LIKE '%World%',
        arrayEnumerate(arr),
        ['Hello', 'abc World'] AS arr)
    AS res
```

```
┌─res─┐
│ [2] │
└─────┘
```

### arrayCount(\[func,\] arr1, ...)
Вернуть количество элементов массива arr, для которых функция func возвращает не 0. Если func не указана - вернуть количество ненулевых элементов массива.

### arrayExists(\[func,\] arr1, ...)
Вернуть 1, если существует хотя бы один элемент массива arr, для которого функция func возвращает не 0. Иначе вернуть 0.

### arrayAll(\[func,\] arr1, ...)
Вернуть 1, если для всех элементов массива arr, функция func возвращает не 0. Иначе вернуть 0.

### arraySum(\[func,\] arr1, ...)
Вернуть сумму значений функции func. Если функция не указана - просто вернуть сумму элементов массива.

### arrayFirst(func, arr1, ...)
Вернуть первый элемент массива arr1, для которого функция func возвращает не 0.

### arrayFirstIndex(func, arr1, ...)
Вернуть индекс первого элемента массива arr1, для которого функция func возвращает не 0.

### arrayCumSum(\[func,\] arr1, ...)

Возвращает массив из частичных сумм элементов исходного массива (сумма с накоплением). Если указана функция `func`, то значения элементов массива преобразуются этой функцией перед суммированием.

Пример:

``` sql
SELECT arrayCumSum([1, 1, 1, 1]) AS res
```

```
┌─res──────────┐
│ [1, 2, 3, 4] │
└──────────────┘
```


### arraySort(\[func,\] arr1, ...)

Возвращает отсортированный в восходящем порядке массив `arr1`. Если задана функция `func`, то порядок сортировки определяется результатом применения функции `func` на элементы массива (массивов).  

Для улучшения эффективности сортировки применяется [Преобразование Шварца](https://ru.wikipedia.org/wiki/%D0%9F%D1%80%D0%B5%D0%BE%D0%B1%D1%80%D0%B0%D0%B7%D0%BE%D0%B2%D0%B0%D0%BD%D0%B8%D0%B5_%D0%A8%D0%B2%D0%B0%D1%80%D1%86%D0%B0).

Пример:

``` sql
SELECT arraySort((x, y) -> y, ['hello', 'world'], [2, 1]);
```

```
┌─res────────────────┐
│ ['world', 'hello'] │
└────────────────────┘
```

### arrayReverseSort(\[func,\] arr1, ...)

Возвращает отсортированный в нисходящем порядке массив `arr1`. Если задана функция `func`, то порядок сортировки определяется результатом применения функции `func` на элементы массива (массивов).  

[Оригинальная статья](https://clickhouse.yandex/docs/ru/query_language/functions/higher_order_functions/) <!--hide-->
