/*****************************************************************************
 *
 *  Copyright (C) 2003 Cdric Brgardis <cedric.bregardis@free.fr>
 *
 *  This file is part of BRIQUOLO
 *
 *  BRIQUOLO is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  BRIQUOLO is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with BRIQUOLO; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *****************************************************************************/
#ifndef MOGL_POLICEBITMAP
#define MOGL_POLICEBITMAP

#include "MOGL_Structure.h"
#include "MOGL_Police.h"

using namespace std;

class MOGL_PoliceBitmap: public MOGL_Police
{
    // **** Types locaux  la classe ****
    struct MOGL_Struct_Carac
    {
        unsigned char carac;
        unsigned int x1;
        unsigned int y1;
        unsigned int x2;
        unsigned int y2;
    };
    // **********************************

  public:
    /**
       Constructeur
    */
    MOGL_PoliceBitmap();

    /**
       Destructeur
    */
    ~MOGL_PoliceBitmap();

    /**
       Permet de Charger  une police de caractres.
    */
    bool Charger(const char * p_NomFichier);

    /**
       Permet d'afficher une chaine de caractres.
       @param p_Chaine : chaine de caractres  afficher.
       @param p_X : coordonne X de la chaine de caractres.
       @param p_Y : coordonne Y de la chaine de caractres.       
       @param p_CouleurTexte : couleur de la chaine de caractres.
    */
    void Afficher(const string & p_Chaine, int p_X, int p_Y, const MOGL_Struct_Couleur & p_CouleurTexte) const;

    /**
       Permet d'afficher une chaine de caractres.
       @param p_Chaine : chaine de caractres  afficher.
       @param p_X : coordonne X de la chaine de caractres.
       @param p_Y : coordonne Y de la chaine de caractres.       
       @param p_CouleurTexte : couleur de la chaine de caractres.
       @param p_CouleurFond : couleur du fond.
    */
    void Afficher(const string & p_Chaine, int p_X, int p_Y,
                  const MOGL_Struct_Couleur & p_CouleurTexte, const MOGL_Struct_Couleur & p_CouleurFond) const;

    /**
       Permet de rcuprer la largeur d'un caractre de la police.
       @param p_Caractere : caractre dont on veut la largeur.
       @return la largeur du caractre en pixels.
    */
    unsigned int GetTailleXCaractere(Uint16 p_Caractere) const;

    /**
       Permet de rcuprer la hauteur d'un caractre de la police.
       @param p_Caractere : caractre dont on veut la hauteur.
       @return la hauteur du caractre en pixels.
    */
    unsigned int GetTailleYCaractere(Uint16 p_Caractere) const;

    /**
       Permet de recharger la police.
    */
    bool Recharger();


  protected:
    /**
       Permet d'afficher un caractre
       @param p_X : position X du caractre
       @param p_Y : position Y du caractre
       @param p_Caractere : caractre  afficher.
       @return Position x du prochain caractre
    */
    float _AfficherCaractere(float p_X, float p_Y, unsigned char p_Caractere) const;

    /**
       Permet d'afficher le fond d'un caractre.
       Il s'agit en fait d'afficher un rectangle de la taille du caractre, et de couleur unie.
       @param p_X : position X du caractre
       @param p_Y : position Y du caractre
       @param p_Caractere : caractre  afficher.
       @return Position x du prochain caractre
    */
    float _AfficherFondCaractere(float p_X, float p_Y, unsigned char p_Caractere) const;
        
    GLuint _Nom;
    unsigned int _TailleX;
    unsigned int _TailleY;
    MOGL_Struct_Couleur * _Image;

    unsigned int _NbCaractere;
    MOGL_Struct_Carac * _Caracteres;
    MOGL_Struct_Carac * (_Correspondance[256-32]);
};

#endif
