#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2018 Mopi
# SPDX-FileCopyrightText: © 2023 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Habitat
# send your bug reports to bugs@dotslashplay.it
###

script_version=20251016.2

PLAYIT_COMPATIBILITY_LEVEL='2.33'

GAME_ID='habitat'
GAME_NAME='Habitat'

ARCHIVE_BASE_0_NAME='Habitat_LinuxUniversal.zip'
ARCHIVE_BASE_0_MD5='f845ef815eb821fdc6124f9cd1b5ca8f'
ARCHIVE_BASE_0_SIZE='1499636'
ARCHIVE_BASE_0_VERSION='1.0-humble160219'
ARCHIVE_BASE_0_URL='https://www.humblebundle.com/store/habitat'

UNITY3D_NAME='Habitat'
UNITY3D_PLUGINS='
libFbxImport.so
ScreenSelector.so'

CONTENT_PATH_DEFAULT='Habitat_LinuxUniversal'

PACKAGES_LIST='
PKG_BIN64
PKG_BIN32
PKG_DATA'

PKG_BIN64_ARCH='64'
PKG_BIN32_ARCH='32'
PKG_BIN_DEPENDENCIES_SIBLINGS='
PKG_DATA'
PKG_BIN_DEPENDENCIES_LIBRARIES='
libc.so.6
libdl.so.2
libgcc_s.so.1
libgdk_pixbuf-2.0.so.0
libglib-2.0.so.0
libGL.so.1
libGLU.so.1
libgobject-2.0.so.0
libgtk-x11-2.0.so.0
libm.so.6
libpthread.so.0
librt.so.1
libstdc++.so.6
libX11.so.6
libXcursor.so.1'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

# Load common functions.

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Run default initialisation actions.

initialization_default "$@"

# Extract game data.

archive_extraction_default
## Delete MacOS junk.
find "${PLAYIT_WORKDIR}/gamedata/$(content_path_default)" -name '*.rsrc' -delete

# Include game data.

content_inclusion_icons 'PKG_DATA'
content_inclusion_default

# Write launchers.

launchers_generation 'PKG_BIN64'
launchers_generation 'PKG_BIN32'

# Build packages.

packages_generation
print_instructions

# Clean up.

working_directory_cleanup

exit 0
